CREATE TABLE PACKAGE_TALEND
(
    PACKAGE_FILE_ID INTEGER PRIMARY KEY,
    STATISTICS BOOLEAN,
    JOB VARCHAR (255),
    JOB_VERSION VARCHAR (100),
    DATE VARCHAR (100),
    CONTEXT_NAME VARCHAR (100),
    JOB_ID VARCHAR (100),
    PROJECT_ID VARCHAR (100),
    APPLY_CONTEXT_TO_CHILDREN BOOLEAN,
    PROJECT VARCHAR (100),
    BRANCH VARCHAR (100),
    CMD_LINE_VERSION VARCHAR (100),
    JAVA_PARAMS VARCHAR (255),
    CONSTRAINT PACKAGE_TALEND_PACKAGE_FILE_PACKAGE_FILE_ID_FK FOREIGN KEY (PACKAGE_FILE_ID) REFERENCES PACKAGE_FILE (ID)
        ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE TABLE PACKAGE_TALEND_PARAMS
(
    PACKAGE_FILE_ID              INTEGER NOT NULL,
    PARAM_NAME VARCHAR (255) NOT NULL,
    PARAM_TYPE VARCHAR(20) DEFAULT 'STRING' NOT NULL,
    PARAM_VALUE VARCHAR (10000),
    PRIMARY KEY (PACKAGE_FILE_ID, PARAM_NAME),
    CONSTRAINT PACKAGE_TALEND_PARAMS_PACKAGE_TALEND_PACKAGE_FILE_ID_FK FOREIGN KEY (PACKAGE_FILE_ID) REFERENCES PACKAGE_TALEND (PACKAGE_FILE_ID)
        ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE SEQUENCE S_OPERATOR_TALEND_PARAMS START WITH 1 INCREMENT BY 1;
CREATE TABLE OPERATOR_TALEND_PARAMS
(
    ID            INTEGER  DEFAULT NEXTVAL('S_OPERATOR_TALEND_PARAMS') PRIMARY KEY,
    STRUCTURE_ID  INTEGER              NOT NULL,
    PARAM_NAME    VARCHAR(255)         NOT NULL,
    PARAM_VALUE   VARCHAR(10000),
    IS_ACTIVE     BOOLEAN DEFAULT TRUE NOT NULL,
    UNIQUE (STRUCTURE_ID, PARAM_NAME),
    CONSTRAINT OPERATOR_TALEND_PARAMS_OPERATOR_STRUCTURE_ID_FK
        FOREIGN KEY (STRUCTURE_ID) REFERENCES OPERATOR
            ON UPDATE CASCADE ON DELETE CASCADE
);