CREATE TABLE OPERATOR_RULE
(
    STRUCTURE_ID             INTEGER PRIMARY KEY,
    RULE_AUTO_STOP_INTERVAL  INTEGER DEFAULT 0     NOT NULL,
    RULE_AUTO_STOP           BOOLEAN DEFAULT FALSE NOT NULL,
    RULE_AUTO_STOP_SUBSCRIBE BOOLEAN DEFAULT FALSE NOT NULL,
    RULE_REPEAT_COUNT        INTEGER DEFAULT 0     NOT NULL,
    RULE_REPEAT_SLEEP        INTEGER DEFAULT 0     NOT NULL,
    CONSTRAINT OPERATOR_RULE_OPERATOR_STRUCTURE_ID_FK
        FOREIGN KEY (STRUCTURE_ID) REFERENCES OPERATOR (STRUCTURE_ID)
            ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE TABLE OPERATOR_RULE_ERROR_STATUS
(
    STRUCTURE_ID INTEGER     NOT NULL,
    STATUS       VARCHAR(20) NOT NULL,
    PRIMARY KEY (STRUCTURE_ID, STATUS)
);

CREATE SEQUENCE S_JOB_RULE_TRIGGER START WITH 1 INCREMENT BY 1;
CREATE TABLE JOB_RULE_TRIGGER
(
    ID              LONG    DEFAULT NEXTVAL('S_JOB_RULE_TRIGGER') PRIMARY KEY,
    CLASS_NAME      VARCHAR(1000)         NOT NULL,
    TITLE           VARCHAR(1000)         NOT NULL,
    //TYPE    VARCHAR(20)           NOT NULL,
    JOB_DATA        JSON,
    REPEAT_COUNT    INTEGER DEFAULT 0     NOT NULL,
    REPEAT_INTERVAL INTEGER               NOT NULL,
    TRIES           INTEGER DEFAULT 0     NOT NULL,
    COMPLETED       BOOLEAN DEFAULT FALSE NOT NULL,
    START_TIME      TIMESTAMP             NOT NULL
);

DROP TABLE WORKFLOW_RULE;