/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.easydata.scheduler.backend.dto.WorkflowDto;
import ru.easydata.scheduler.backend.dto.WorkflowListDto;
import ru.easydata.scheduler.backend.entities.OperatorBashEntity;
import ru.easydata.scheduler.backend.entities.OperatorStructureEntity;
import ru.easydata.scheduler.backend.entities.WorkflowEntity;
import ru.easydata.scheduler.backend.enums.OperatorCategory;
import ru.easydata.scheduler.backend.enums.OperatorType;
import ru.easydata.scheduler.backend.enums.WorkflowType;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.WorkflowMapper;
import ru.easydata.scheduler.backend.repositoryes.OperatorBashRepository;
import ru.easydata.scheduler.backend.repositoryes.OperatorParamRepository;
import ru.easydata.scheduler.backend.repositoryes.OperatorStructureRepository;
import ru.easydata.scheduler.backend.repositoryes.WorkflowParamRepository;
import ru.easydata.scheduler.backend.repositoryes.WorkflowRepository;
import ru.easydata.scheduler.backend.repositoryes.WorkflowTriggerRepositoryImpl;
import ru.easydata.scheduler.backend.service.WorkflowService;
import ru.easydata.scheduler.backend.service.impl.WorkflowImpl;
import ru.easydata.scheduler.worker.executors.ExecutorStatus;

@Service(value="workflowService")
public class WorkflowImpl
implements WorkflowService,
GroovyObject {
    @Autowired
    protected WorkflowRepository workflowRepository;
    @Autowired
    protected OperatorStructureRepository operatorStructureRepository;
    @Autowired
    protected WorkflowMapper workflowMapper;
    @Autowired
    protected WorkflowTriggerRepositoryImpl workflowTriggerRepository;
    @Autowired
    protected WorkflowParamRepository workflowParamRepository;
    @Autowired
    protected OperatorBashRepository operatorBashRepository;
    @Autowired
    protected OperatorParamRepository operatorParamRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public WorkflowImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<WorkflowListDto> list() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllByList", 0, this.workflowRepository));
    }

    public WorkflowDto get(Integer id) throws SchedulerException {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, IndyInterface.bootstrap("invoke", "findWorkflowEntity", 2, this, id)));
    }

    @Transactional
    public WorkflowDto create(Integer projectId, WorkflowDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Integer n = projectId;
            valueRecorder.record((Object)n, 8);
            WorkflowDto workflowDto = dto;
            valueRecorder.record((Object)workflowDto, 21);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "projectId", 4, workflowDto);
            valueRecorder.record((Object)callSite, 25);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)n, (Object)callSite);
            valueRecorder.record((Object)bl, 18);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert projectId == dto.projectId", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite workflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createWorkflow", 2, this, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, dto)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, workflowEntity));
    }

    public WorkflowDto update(Integer id, WorkflowDto dto) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            WorkflowDto workflowDto = dto;
            valueRecorder.record((Object)workflowDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, workflowDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            WorkflowDto workflowDto = dto;
            valueRecorder2.record((Object)workflowDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, workflowDto);
            valueRecorder2.record((Object)callSite, 12);
            Integer n = id;
            valueRecorder2.record((Object)n, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder2.record((Object)bl, 15);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id == id", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite workflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveWorkflow", 2, this, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, dto)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, workflowEntity));
    }

    @Transactional
    public WorkflowDto copy(Integer workflowId) {
        CallSite workflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findWorkflowEntity", 2, this, workflowId));
        CallSite newWorkflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createWorkflow", 2, this, IndyInterface.bootstrap("init", "<init>", 0, WorkflowEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"title", IndyInterface.bootstrap("invoke", "makeCopyTitle", 2, this, IndyInterface.bootstrap("getProperty", "title", 4, workflowEntity)), "projectId", IndyInterface.bootstrap("getProperty", "projectId", 4, workflowEntity), "serverId", IndyInterface.bootstrap("getProperty", "serverId", 4, workflowEntity), "enabled", false, "description", IndyInterface.bootstrap("getProperty", "description", 4, workflowEntity)}))));
        CallSite newOperatorStructureEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findStartStep", 0, this.operatorStructureRepository, IndyInterface.bootstrap("getProperty", "id", 4, newWorkflowEntity))));
        IndyInterface.bootstrap("invoke", "copyTrigger", 2, this, workflowId, IndyInterface.bootstrap("getProperty", "id", 4, newWorkflowEntity));
        IndyInterface.bootstrap("invoke", "copyParams", 2, this, workflowId, IndyInterface.bootstrap("getProperty", "id", 4, newWorkflowEntity));
        CallSite step = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findStartStep", 0, this.operatorStructureRepository, workflowId)));
        IndyInterface.bootstrap("invoke", "copyStep", 2, this, step, newWorkflowEntity, IndyInterface.bootstrap("getProperty", "id", 4, newOperatorStructureEntity));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.workflowMapper, newWorkflowEntity));
    }

    public boolean delete(Integer id) {
        try {
            IndyInterface.bootstrap("invoke", "deleteById", 0, this.workflowRepository, id);
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    public boolean enable(Integer id) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "saveWorkflowEnabled", 2, this, id, true));
    }

    public boolean disable(Integer id) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "saveWorkflowEnabled", 2, this, id, false));
    }

    protected void copyParams(Integer workflowId, Integer newWorkflowId) {
        Reference newWorkflowId2 = new Reference((Object)newWorkflowId);
        CallSite params = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.workflowParamRepository, workflowId));
        IndyInterface.bootstrap("invoke", "each", 0, params, new _copyParams_closure1((Object)this, (Object)this, newWorkflowId2));
    }

    protected void copyTrigger(Integer workflowId, Integer newWorkflowId) {
        Reference newWorkflowId2 = new Reference((Object)newWorkflowId);
        CallSite triggers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.workflowTriggerRepository, workflowId));
        IndyInterface.bootstrap("invoke", "each", 0, triggers, new _copyTrigger_closure2((Object)this, (Object)this, newWorkflowId2));
    }

    /*
     * WARNING - void declaration
     */
    protected void copyStep(OperatorStructureEntity step, WorkflowEntity newWorkflow, Integer newParentId) {
        void var3_3;
        Reference newWorkflow2 = new Reference((Object)newWorkflow);
        Reference newParentId2 = new Reference((Object)var3_3);
        CallSite stepList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllOperatorByStep", 0, this.operatorStructureRepository, IndyInterface.bootstrap("getProperty", "id", 4, step)));
        IndyInterface.bootstrap("invoke", "each", 0, stepList, new _copyStep_closure3((Object)this, (Object)this, newWorkflow2, newParentId2));
    }

    protected Integer copyOperator(OperatorStructureEntity entity, WorkflowEntity newWorkflow, Integer newParentId) {
        CallSite operatorBashEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.operatorBashRepository, IndyInterface.bootstrap("getProperty", "id", 4, entity))));
        CallSite newOperatorBashEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.operatorBashRepository, IndyInterface.bootstrap("init", "<init>", 0, OperatorBashEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"parentId", newParentId, "workflow", newWorkflow, "command", IndyInterface.bootstrap("getProperty", "command", 4, operatorBashEntity), "commandDirectory", IndyInterface.bootstrap("getProperty", "commandDirectory", 4, operatorBashEntity), "category", IndyInterface.bootstrap("getProperty", "category", 4, entity), "orderCategory", IndyInterface.bootstrap("getProperty", "orderCategory", 4, entity), "type", IndyInterface.bootstrap("getProperty", "type", 4, entity), "status", IndyInterface.bootstrap("getProperty", "EMPTY", 0, ExecutorStatus.class), "isEnabled", IndyInterface.bootstrap("getProperty", "isEnabled", 4, entity), "title", IndyInterface.bootstrap("getProperty", "title", 4, entity), "ruleErrorStatus", IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "ruleErrorStatus", 4, operatorBashEntity)), "ruleAutoStopInterval", IndyInterface.bootstrap("getProperty", "ruleAutoStopInterval", 4, operatorBashEntity), "ruleAutoStop", IndyInterface.bootstrap("getProperty", "ruleAutoStop", 4, operatorBashEntity), "ruleAutoStopSubscribe", IndyInterface.bootstrap("getProperty", "ruleAutoStopSubscribe", 4, operatorBashEntity), "ruleRepeatCount", IndyInterface.bootstrap("getProperty", "ruleRepeatCount", 4, operatorBashEntity), "ruleRepeatSleep", IndyInterface.bootstrap("getProperty", "ruleRepeatSleep", 4, operatorBashEntity)}))));
        IndyInterface.bootstrap("invoke", "copyOperatorParams", 2, this, IndyInterface.bootstrap("getProperty", "id", 4, entity), IndyInterface.bootstrap("getProperty", "id", 4, newOperatorBashEntity));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 4, newOperatorBashEntity));
    }

    protected void copyOperatorParams(Integer operatorId, Integer newOperatorId) {
        Reference newOperatorId2 = new Reference((Object)newOperatorId);
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.operatorParamRepository, operatorId), new _copyOperatorParams_closure4((Object)this, (Object)this, newOperatorId2));
    }

    protected String makeCopyTitle(String title) {
        CallSite pattern = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, "(\\(\\D+\\d*\\))"));
        CallSite matcher = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matcher", 0, pattern, title));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, matcher)) != false) {
            CallSite group1 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "group", 0, matcher, true));
            title = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, title, group1, ""));
        }
        CallSite sizeTitle = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sizeTitle", 0, this.workflowRepository, title));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)sizeTitle, (Object)0)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, title, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, sizeTitle, true)}, new String[]{"(\u043a\u043e\u043f\u0438\u044f ", ")"})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, title, "(\u043a\u043e\u043f\u0438\u044f)"));
    }

    protected Object createWorkflow(WorkflowEntity workflowEntity) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            WorkflowEntity workflowEntity2 = workflowEntity;
            valueRecorder.record((Object)workflowEntity2, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, workflowEntity2);
            valueRecorder.record((Object)callSite, 24);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !workflowEntity.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "WORKFLOW", 0, WorkflowType.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, WorkflowImpl.class, (GroovyObject)workflowEntity, (String)"type");
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "EMPTY", 0, ExecutorStatus.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, WorkflowImpl.class, (GroovyObject)workflowEntity, (String)"status");
        Object var5_5 = null;
        ScriptBytecodeAdapter.setGroovyObjectProperty(var5_5, WorkflowImpl.class, (GroovyObject)workflowEntity, (String)"startDateTime");
        CallSite newWorkflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveWorkflow", 2, this, workflowEntity));
        IndyInterface.bootstrap("invoke", "saveOperatorStructure", 2, this, IndyInterface.bootstrap("init", "<init>", 0, OperatorStructureEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"category", IndyInterface.bootstrap("getProperty", "START", 0, OperatorCategory.class), "orderCategory", 0, "workflowId", IndyInterface.bootstrap("getProperty", "id", 4, newWorkflowEntity), "parentId", null, "status", IndyInterface.bootstrap("getProperty", "EMPTY", 0, ExecutorStatus.class), "type", IndyInterface.bootstrap("getProperty", "NONE", 0, OperatorType.class)})));
        return newWorkflowEntity;
    }

    protected boolean saveWorkflowEnabled(Integer workflowId, boolean enable) {
        CallSite entity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findWorkflowEntity", 2, this, workflowId));
        boolean bl = enable;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, WorkflowImpl.class, (GroovyObject)entity, (String)"enabled");
        try {
            IndyInterface.bootstrap("invoke", "save", 0, this.workflowRepository, entity);
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    protected WorkflowEntity findWorkflowEntity(Integer id) throws SchedulerException {
        Reference id2 = new Reference((Object)id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.workflowRepository, (Integer)id2.get()), new _findWorkflowEntity_closure5((Object)this, (Object)this, id2)));
    }

    protected WorkflowEntity saveWorkflow(WorkflowEntity workflowEntity) throws SchedulerException {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "serverId", 4, workflowEntity), (Object)0)) {
            Object var2_2 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var2_2, WorkflowImpl.class, (GroovyObject)workflowEntity, (String)"serverId");
        }
        workflowEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.workflowRepository, workflowEntity));
        ValueRecorder valueRecorder = new ValueRecorder();
        Object object = workflowEntity;
        valueRecorder.record(object, 8);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, object);
        valueRecorder.record((Object)callSite, 23);
        if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
            throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert workflowEntity.id", (ValueRecorder)valueRecorder), null);
        }
        valueRecorder.clear();
        Object object2 = workflowEntity;
        try {
            return object2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected OperatorStructureEntity saveOperatorStructure(OperatorStructureEntity operatorStructureEntity) throws SchedulerException {
        operatorStructureEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.operatorStructureRepository, operatorStructureEntity));
        ValueRecorder valueRecorder = new ValueRecorder();
        Object object = operatorStructureEntity;
        valueRecorder.record(object, 8);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, object);
        valueRecorder.record((Object)callSite, 32);
        if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
            throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert operatorStructureEntity.id", (ValueRecorder)valueRecorder), null);
        }
        valueRecorder.clear();
        Object object2 = operatorStructureEntity;
        try {
            return object2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != WorkflowImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

