/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.validation.Valid;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.passay.CharacterRule;
import org.passay.CyrillicCharacterData;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.WhitespaceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import ru.easydata.scheduler.backend.config.AppProperties;
import ru.easydata.scheduler.backend.dto.UserChangePasswordDto;
import ru.easydata.scheduler.backend.dto.UserClaims;
import ru.easydata.scheduler.backend.dto.UserDto;
import ru.easydata.scheduler.backend.dto.UserNewDto;
import ru.easydata.scheduler.backend.dto.UserRoleDto;
import ru.easydata.scheduler.backend.entities.RoleEntity;
import ru.easydata.scheduler.backend.entities.UserEntity;
import ru.easydata.scheduler.backend.exception.SchedulerClientException;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.UserMapper;
import ru.easydata.scheduler.backend.repositoryes.RoleRepository;
import ru.easydata.scheduler.backend.repositoryes.UserPasswordOldRepository;
import ru.easydata.scheduler.backend.repositoryes.UserRepository;
import ru.easydata.scheduler.backend.service.UserService;
import ru.easydata.scheduler.backend.service.impl.UserImpl;

@Service(value="userService")
@Lazy
@Validated
public class UserImpl
implements UserService,
GroovyObject {
    @Autowired
    protected AppProperties appProperties;
    @Autowired
    protected UserPasswordOldRepository userPasswordOldRepository;
    @Autowired
    @Qualifier(value="authenticationUser")
    protected UserClaims authenticationUser;
    @Autowired
    protected RoleRepository roleRepository;
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected UserMapper userMapper;
    @Autowired
    protected PasswordEncoder passwordEncoder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public UserImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public UserDto model(Integer id) throws SchedulerException {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.userMapper, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, id)));
    }

    public List<UserDto> list() {
        CallSite userEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.userRepository, IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "ASC", 0, Sort.Direction.class), "email")));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, userEntities), new _list_closure1((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public UserDto create(@Valid UserNewDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UserNewDto userNewDto = dto;
            valueRecorder.record((Object)userNewDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userNewDto);
            valueRecorder.record((Object)callSite, 13);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite entity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newUser", 2, this, dto));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.userMapper, IndyInterface.bootstrap("invoke", "saveUser", 2, this, entity)));
    }

    public UserDto update(Integer id, @Valid UserDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UserDto userDto = dto;
            valueRecorder.record((Object)userDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Integer n = id;
            valueRecorder2.record((Object)n, 8);
            UserDto userDto = dto;
            valueRecorder2.record((Object)userDto, 14);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userDto);
            valueRecorder2.record((Object)callSite, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)n, (Object)callSite);
            valueRecorder2.record((Object)bl, 11);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert id == dto.id", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, IndyInterface.bootstrap("getProperty", "id", 4, dto)));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "email", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UserImpl.class, (GroovyObject)userEntity, (String)"email");
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "fullName", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, UserImpl.class, (GroovyObject)userEntity, (String)"fullName");
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "login", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, UserImpl.class, (GroovyObject)userEntity, (String)"login");
        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "description", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, UserImpl.class, (GroovyObject)userEntity, (String)"description");
        CallSite callSite5 = IndyInterface.bootstrap("getProperty", "isSubscribed", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, UserImpl.class, (GroovyObject)userEntity, (String)"isSubscribed");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.userMapper, IndyInterface.bootstrap("invoke", "saveUser", 2, this, userEntity)));
    }

    public boolean changePassword(Integer userId, @Valid UserChangePasswordDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UserChangePasswordDto userChangePasswordDto = dto;
            valueRecorder.record((Object)userChangePasswordDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userChangePasswordDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Integer n = userId;
            valueRecorder2.record((Object)n, 8);
            UserChangePasswordDto userChangePasswordDto = dto;
            valueRecorder2.record((Object)userChangePasswordDto, 18);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userChangePasswordDto);
            valueRecorder2.record((Object)callSite, 22);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)n, (Object)callSite);
            valueRecorder2.record((Object)bl, 15);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert userId == dto.id", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, IndyInterface.bootstrap("getProperty", "id", 4, dto)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, this.passwordEncoder, IndyInterface.bootstrap("getProperty", "password", 4, userEntity), IndyInterface.bootstrap("getProperty", "passwordOld", 4, dto))) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, "\u0421\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439"));
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "passwordValidator", 2, this, IndyInterface.bootstrap("getProperty", "id", 4, dto), IndyInterface.bootstrap("getProperty", "password", 4, dto), IndyInterface.bootstrap("getProperty", "passwordConfirmation", 4, dto));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UserImpl.class, (GroovyObject)userEntity, (String)"password");
        IndyInterface.bootstrap("invoke", "saveUser", 2, this, userEntity);
        return true;
    }

    public boolean changePassword(Integer userId, String password, String passwordConfirmation) throws SchedulerException {
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, userId));
        CallSite callSite = IndyInterface.bootstrap("invoke", "passwordValidator", 2, this, userId, password, passwordConfirmation);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UserImpl.class, (GroovyObject)userEntity, (String)"password");
        IndyInterface.bootstrap("invoke", "saveUser", 2, this, userEntity);
        return true;
    }

    public UserDto remindPassword(String email) throws SchedulerException {
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public boolean enable(Integer userId) throws SchedulerException {
        IndyInterface.bootstrap("invoke", "saveActive", 2, this, userId, true);
        return true;
    }

    public boolean disable(Integer userId) throws SchedulerException {
        IndyInterface.bootstrap("invoke", "saveActive", 2, this, userId, false);
        return true;
    }

    public boolean delete(Integer id) throws SchedulerException {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "userId", 1, this.authenticationUser), (Object)id)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, "\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c"));
        }
        try {
            IndyInterface.bootstrap("invoke", "deleteById", 0, this.userRepository, id);
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    public UserDto register(@Valid UserNewDto dto) throws SchedulerException {
        CallSite entity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newUser", 2, this, dto));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "list", 2, this)), (Object)0)) {
            boolean bl = false;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, UserImpl.class, (GroovyObject)entity, (String)"isEnabled");
        } else {
            boolean bl = true;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, UserImpl.class, (GroovyObject)entity, (String)"isEnabled");
            IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "roles", 4, entity), IndyInterface.bootstrap("invoke", "NewUser", 0, RoleEntity.class));
            IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "roles", 4, entity), IndyInterface.bootstrap("invoke", "NewAdmin", 0, RoleEntity.class));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.userMapper, IndyInterface.bootstrap("invoke", "saveUser", 2, this, entity)));
    }

    public List<UserRoleDto> roleList(Integer userId) {
        Reference userId2 = new Reference((Object)userId);
        Reference roles = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite rolesEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.roleRepository));
        Reference userEntity = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, (Integer)userId2.get())));
        IndyInterface.bootstrap("invoke", "each", 0, rolesEntity, new _roleList_closure2((Object)this, (Object)this, roles, userId2, userEntity));
        return (List)roles.get();
    }

    public boolean roleAdd(Integer userId, Integer roleId) throws SchedulerException {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "role", 2, this, userId, roleId, new _roleAdd_closure3((Object)this, (Object)this)));
    }

    public boolean roleRemote(Integer userId, Integer roleId) throws SchedulerException {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "role", 2, this, userId, roleId, new _roleRemote_closure4((Object)this, (Object)this)));
    }

    protected boolean role(Integer userId, Integer roleId, Closure<UserEntity> areaCalculator) {
        Reference roleId2 = new Reference((Object)roleId);
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, userId));
        CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.roleRepository, (Integer)roleId2.get()), new _role_closure5((Object)this, (Object)this, roleId2)));
        IndyInterface.bootstrap("invoke", "saveUser", 2, this, IndyInterface.bootstrap("invoke", "call", 0, areaCalculator, userEntity, roleEntity));
        return true;
    }

    protected UserEntity newUser(UserNewDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UserNewDto userNewDto = dto;
            valueRecorder.record((Object)userNewDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, userNewDto);
            valueRecorder.record((Object)callSite, 13);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.userMapper, dto));
        CallSite callSite = IndyInterface.bootstrap("invoke", "passwordValidator", 2, this, IndyInterface.bootstrap("getProperty", "password", 4, dto), IndyInterface.bootstrap("getProperty", "passwordConfirmation", 4, dto));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UserImpl.class, (GroovyObject)userEntity, (String)"password");
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "toTimestamp", 0, IndyInterface.bootstrap("init", "<init>", 0, Date.class));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, UserImpl.class, (GroovyObject)userEntity, (String)"registeredDate");
        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "roles", 4, userEntity), IndyInterface.bootstrap("invoke", "NewUser", 0, RoleEntity.class));
        return userEntity;
    }

    protected UserEntity saveActive(Integer userId, boolean active) {
        CallSite userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findUserEntity", 2, this, userId));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "userId", 1, this.authenticationUser), (Object)userId)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, "\u041d\u0435\u043b\u044c\u0437\u044f \u0441\u043d\u044f\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c \u0441\u043e \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f"));
        }
        boolean bl = active;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, UserImpl.class, (GroovyObject)userEntity, (String)"isEnabled");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveUser", 2, this, userEntity));
    }

    protected UserEntity findUserEntity(Integer id) throws SchedulerException {
        Reference id2 = new Reference((Object)id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.userRepository, (Integer)id2.get()), new _findUserEntity_closure6((Object)this, (Object)this, id2)));
    }

    protected UserEntity saveUser(UserEntity userEntity) throws SchedulerException {
        userEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.userRepository, userEntity));
        ValueRecorder valueRecorder = new ValueRecorder();
        Object object = userEntity;
        valueRecorder.record(object, 8);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, object);
        valueRecorder.record((Object)callSite, 19);
        if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
            throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert userEntity.id", (ValueRecorder)valueRecorder), null);
        }
        valueRecorder.clear();
        Object object2 = userEntity;
        try {
            return object2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected String passwordValidator(Integer userId, String password, String passwordConfirmation) throws SchedulerException {
        Reference password2 = new Reference((Object)password);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordStore", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            CallSite topTen = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, PageRequest.class, false, IndyInterface.bootstrap("getProperty", "passwordStore", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "DESC", 0, Sort.Direction.class), "dateCreate")));
            IndyInterface.bootstrap("invoke", "forEach", 0, IndyInterface.bootstrap("invoke", "findAllByUserId", 0, this.userPasswordOldRepository, userId, topTen), new _passwordValidator_closure7((Object)this, (Object)this, password2));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "passwordValidator", 2, this, (String)password2.get(), passwordConfirmation));
    }

    protected String passwordValidator(String password, String passwordConfirmation) throws SchedulerException {
        Reference password2 = new Reference((Object)password);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "passwordBlackList", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), new _passwordValidator_closure8((Object)this, (Object)this, password2))) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, "\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0447\u0435\u0440\u043d\u043e\u043c \u0441\u043f\u0438\u0441\u043a\u0435"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)passwordConfirmation) && ScriptBytecodeAdapter.compareNotEqual((Object)((String)password2.get()), (Object)passwordConfirmation)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, "\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442"));
        }
        List ruleList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, WhitespaceRule.class));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordMinLength", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, LengthRule.class, IndyInterface.bootstrap("getProperty", "passwordMinLength", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class)));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordRuleUpperCase", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, CharacterRule.class, IndyInterface.bootstrap("getProperty", "UpperCase", 0, CyrillicCharacterData.class), IndyInterface.bootstrap("getProperty", "passwordRuleUpperCase", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordRuleLowerCase", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, CharacterRule.class, IndyInterface.bootstrap("getProperty", "LowerCase", 0, CyrillicCharacterData.class), IndyInterface.bootstrap("getProperty", "passwordRuleLowerCase", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordRuleDigit", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, CharacterRule.class, IndyInterface.bootstrap("getProperty", "Digit", 0, EnglishCharacterData.class), IndyInterface.bootstrap("getProperty", "passwordRuleDigit", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "passwordRuleSpecial", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties)), (Object)0)) {
            IndyInterface.bootstrap("invoke", "add", 0, ruleList, IndyInterface.bootstrap("init", "<init>", 0, CharacterRule.class, IndyInterface.bootstrap("getProperty", "Special", 0, EnglishCharacterData.class), IndyInterface.bootstrap("getProperty", "passwordRuleSpecial", 0, IndyInterface.bootstrap("getProperty", "user", 0, this.appProperties))));
        }
        CallSite validator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PasswordValidator.class, ruleList));
        CallSite ruleResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validate", 0, validator, IndyInterface.bootstrap("init", "<init>", 0, PasswordData.class, (String)password2.get())));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isValid", 0, ruleResult)) == false) {
            CallSite messages = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMessages", 0, validator, ruleResult));
            CallSite messageTemplate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "stream", 0, messages), IndyInterface.bootstrap("invoke", "joining", 0, Collectors.class, ",")));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, messageTemplate));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encode", 0, this.passwordEncoder, (String)password2.get()));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UserImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    protected String passwordValidator(Integer userId, String password) throws SchedulerException {
        Reference password2 = new Reference((Object)password);
        return this.passwordValidator(userId, (String)password2.get(), null);
    }

    @Generated
    protected String passwordValidator(String password) throws SchedulerException {
        Reference password2 = new Reference((Object)password);
        return this.passwordValidator((String)password2.get(), null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.backend.service.impl.UserImpl");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

