/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.validation.Valid;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import ru.easydata.scheduler.backend.dto.ApplicationAccessUserDto;
import ru.easydata.scheduler.backend.dto.RoleDto;
import ru.easydata.scheduler.backend.dto.RoleProjectDto;
import ru.easydata.scheduler.backend.entities.RoleEntity;
import ru.easydata.scheduler.backend.events.ProjectCreateEvent;
import ru.easydata.scheduler.backend.exception.SchedulerClientException;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.RoleMapper;
import ru.easydata.scheduler.backend.repositoryes.ProjectAccessRepository;
import ru.easydata.scheduler.backend.repositoryes.RoleRepository;
import ru.easydata.scheduler.backend.service.RoleService;
import ru.easydata.scheduler.backend.service.impl.RoleImpl;

@Service(value="roleService")
@Lazy
@Validated
public class RoleImpl
implements RoleService,
GroovyObject {
    @Autowired
    protected RoleRepository roleRepository;
    @Autowired
    protected RoleMapper roleMapper;
    @Autowired
    protected ProjectAccessRepository projectAccessRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RoleImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<RoleDto> list() {
        CallSite roleEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.roleRepository, IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "ASC", 0, Sort.Direction.class), "name")));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, roleEntities), new _list_closure1((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public RoleDto model(Integer roleId) throws SchedulerException {
        CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findRoleEntity", 2, this, roleId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, roleEntity));
    }

    public RoleDto create(@Valid RoleDto model) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            RoleDto roleDto = model;
            valueRecorder.record((Object)roleDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, roleDto);
            valueRecorder.record((Object)callSite, 15);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !model.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveRole", 2, this, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, model)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, roleEntity));
    }

    public RoleDto update(Integer roleId, @Valid RoleDto model) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            RoleDto roleDto = model;
            valueRecorder.record((Object)roleDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, roleDto);
            valueRecorder.record((Object)callSite, 14);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert model.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            RoleDto roleDto = model;
            valueRecorder2.record((Object)roleDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, roleDto);
            valueRecorder2.record((Object)callSite, 14);
            Integer n = roleId;
            valueRecorder2.record((Object)n, 20);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder2.record((Object)bl, 17);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert model.id == roleId", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findRoleEntity", 2, this, roleId));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "readOnly", 4, roleEntity)) == false) {
            roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveRole", 2, this, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, model)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, roleEntity));
    }

    public boolean delete(Integer roleId) throws SchedulerException {
        try {
            CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findRoleEntity", 2, this, roleId));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "readOnly", 4, roleEntity)) == false) {
                IndyInterface.bootstrap("invoke", "delete", 0, this.roleRepository, roleEntity);
            }
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    public List<RoleProjectDto> listProjectByRole(Integer roleId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllProjectAccessByRole", 0, this.roleRepository, roleId));
    }

    public List<ApplicationAccessUserDto> listApplicationByRole(Integer roleId) {
        Reference roleId2 = new Reference((Object)roleId);
        Reference roleEntity = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.roleRepository, (Integer)roleId2.get()))));
        Reference list = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "values", 0, RoleEntity.RULES.class), new _listApplicationByRole_closure2((Object)this, (Object)this, list, roleEntity, roleId2));
        return (List)list.get();
    }

    public boolean applicationRoleSave(ApplicationAccessUserDto applicationAccessUserDto) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "roleId", 4, applicationAccessUserDto), (Object)IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("invoke", "NewAdmin", 0, RoleEntity.class)))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, "\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0434\u043b\u044f \u0440\u043e\u043b\u0438 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440"));
        }
        CallSite roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.roleRepository, IndyInterface.bootstrap("getProperty", "roleId", 4, applicationAccessUserDto))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "access", 4, applicationAccessUserDto)) != false) {
            IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "rules", 4, roleEntity), IndyInterface.bootstrap("invoke", "valueOf", 0, RoleEntity.RULES.class, IndyInterface.bootstrap("getProperty", "rule", 4, applicationAccessUserDto)));
        } else {
            IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "rules", 4, roleEntity), IndyInterface.bootstrap("invoke", "valueOf", 0, RoleEntity.RULES.class, IndyInterface.bootstrap("getProperty", "rule", 4, applicationAccessUserDto)));
        }
        try {
            IndyInterface.bootstrap("invoke", "save", 0, this.roleRepository, roleEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    public boolean updateProject(RoleProjectDto roleProjectDto) throws SchedulerException {
        CallSite projectAccessEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.roleMapper, roleProjectDto));
        try {
            IndyInterface.bootstrap("invoke", "save", 0, this.projectAccessRepository, projectAccessEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    @EventListener
    public void projectCreateEvent(ProjectCreateEvent projectCreateEvent) {
        IndyInterface.bootstrap("invoke", "updateProject", 2, this, IndyInterface.bootstrap("init", "<init>", 0, RoleProjectDto.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"projectId", IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "projectEntity", 4, projectCreateEvent)), "roleId", IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("invoke", "NewAdmin", 0, RoleEntity.class)), "projectTitle", IndyInterface.bootstrap("getProperty", "title", 0, IndyInterface.bootstrap("getProperty", "projectEntity", 4, projectCreateEvent)), "roleRead", true, "roleWrite", true, "roleRun", true, "roleDelete", true, "roleSubscribe", true})));
    }

    protected RoleEntity findRoleEntity(Integer id) throws SchedulerException {
        Reference id2 = new Reference((Object)id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.roleRepository, (Integer)id2.get()), new _findRoleEntity_closure3((Object)this, (Object)this, id2)));
    }

    protected RoleEntity saveRole(RoleEntity roleEntity) throws SchedulerException {
        roleEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.roleRepository, roleEntity));
        ValueRecorder valueRecorder = new ValueRecorder();
        Object object = roleEntity;
        valueRecorder.record(object, 8);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, object);
        valueRecorder.record((Object)callSite, 19);
        if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
            throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert roleEntity.id", (ValueRecorder)valueRecorder), null);
        }
        valueRecorder.clear();
        Object object2 = roleEntity;
        try {
            return object2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RoleImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.backend.service.impl.RoleImpl");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

