/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.validation.Valid;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import ru.easydata.scheduler.backend.dto.ProjectDto;
import ru.easydata.scheduler.backend.entities.ProjectEntity;
import ru.easydata.scheduler.backend.events.ProjectCreateEvent;
import ru.easydata.scheduler.backend.events.ProjectDeleteEvent;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.ProjectMapper;
import ru.easydata.scheduler.backend.repositoryes.ProjectRepository;
import ru.easydata.scheduler.backend.service.ProjectService;
import ru.easydata.scheduler.backend.service.SubscribeService;
import ru.easydata.scheduler.backend.service.impl.ProjectImpl;

@Service(value="projectService")
@Lazy
@Validated
public class ProjectImpl
implements ProjectService,
GroovyObject {
    @Autowired
    protected ProjectRepository projectRepository;
    @Autowired
    protected ProjectMapper projectMapper;
    @Autowired
    protected SubscribeService subscribeService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProjectImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ProjectDto get(Integer id) throws SchedulerException {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.projectMapper, IndyInterface.bootstrap("invoke", "findProjectEntity", 2, this, id)));
    }

    public List<ProjectDto> list() {
        CallSite projectEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.projectRepository, IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "ASC", 0, Sort.Direction.class), "title")));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, projectEntities), new _list_closure1((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public List<ProjectDto> list(Integer userId) {
        CallSite projectEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.projectRepository, userId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, projectEntities), new _list_closure2((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    @Transactional
    public ProjectDto create(@Valid ProjectDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            ProjectDto projectDto = dto;
            valueRecorder.record((Object)projectDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, projectDto);
            valueRecorder.record((Object)callSite, 13);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite projectEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "saveProject", 2, this, IndyInterface.bootstrap("invoke", "map", 0, this.projectMapper, dto)));
        IndyInterface.bootstrap("invoke", "publishEvent", 0, this.applicationEventPublisher, IndyInterface.bootstrap("init", "<init>", 0, ProjectCreateEvent.class, this, projectEntity));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.projectMapper, projectEntity));
    }

    public ProjectDto update(Integer id, @Valid ProjectDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            ProjectDto projectDto = dto;
            valueRecorder.record((Object)projectDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, projectDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            ProjectDto projectDto = dto;
            valueRecorder2.record((Object)projectDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, projectDto);
            valueRecorder2.record((Object)callSite, 12);
            Integer n = id;
            valueRecorder2.record((Object)n, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder2.record((Object)bl, 15);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id == id", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite projectEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findProjectEntity", 2, this, id));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "title", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, ProjectImpl.class, (GroovyObject)projectEntity, (String)"title");
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "description", 4, dto);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, ProjectImpl.class, (GroovyObject)projectEntity, (String)"description");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.projectMapper, IndyInterface.bootstrap("invoke", "saveProject", 2, this, projectEntity)));
    }

    public boolean delete(Integer id) throws SchedulerException {
        try {
            IndyInterface.bootstrap("invoke", "deleteById", 0, this.projectRepository, id);
            IndyInterface.bootstrap("invoke", "publishEvent", 0, this.applicationEventPublisher, IndyInterface.bootstrap("init", "<init>", 0, ProjectDeleteEvent.class, this, id));
        }
        catch (DataIntegrityViolationException e) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "message", 0, e), "WORKFLOW_PROJECT_PROJECT_ID_FK")) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442, \u0435\u0441\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u043d\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u044b"));
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    protected ProjectEntity findProjectEntity(Integer id) throws SchedulerException {
        Reference id2 = new Reference((Object)id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.projectRepository, (Integer)id2.get()), new _findProjectEntity_closure3((Object)this, (Object)this, id2)));
    }

    protected ProjectEntity saveProject(ProjectEntity projectEntity) throws SchedulerException {
        projectEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.projectRepository, projectEntity));
        ValueRecorder valueRecorder = new ValueRecorder();
        Object object = projectEntity;
        valueRecorder.record(object, 8);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, object);
        valueRecorder.record((Object)callSite, 22);
        if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
            throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert projectEntity.id", (ValueRecorder)valueRecorder), null);
        }
        valueRecorder.clear();
        Object object2 = projectEntity;
        try {
            return object2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.backend.service.impl.ProjectImpl");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

