/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.controllers.rest.v1;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import ru.easydata.scheduler.backend.controllers.rest.v1.PackageRestControllerV1;
import ru.easydata.scheduler.backend.dto.PackageDto;
import ru.easydata.scheduler.backend.dto.PackageFileDto;
import ru.easydata.scheduler.backend.dto.UserClaims;
import ru.easydata.scheduler.backend.dto.WebixOptionsDto;
import ru.easydata.scheduler.backend.enums.PackageType;
import ru.easydata.scheduler.backend.factories.ServicesFactory;

@RestController
@RequestMapping(value={"/rest/v1/package"})
public class PackageRestControllerV1
implements GroovyObject {
    @Autowired
    private ServicesFactory servicesFactory;
    @Autowired
    @Qualifier(value="authenticationUser")
    private UserClaims authenticationUser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PackageRestControllerV1() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @GetMapping(path={"", "/"})
    public ResponseEntity<List<PackageDto>> index() {
        CallSite list = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listPackage", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, list));
    }

    @GetMapping(path={"/files"})
    public ResponseEntity<List<PackageFileDto>> listFiles(@RequestParam(value="packageId") Integer packageId) {
        CallSite list = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listFile", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), packageId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, list));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PackageDto> show(@PathVariable(value="id") Integer id) {
        CallSite packageDto = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), id));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, packageDto));
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<PackageDto> store(@RequestParam(value="upload") MultipartFile multipartFile, @RequestParam(value="code") String code, @RequestParam(value="projectId") Integer projectId, @RequestParam(value="description") String description) {
        CallSite packageDto = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PackageDto.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"code", code, "projectId", projectId, "description", description})));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, IndyInterface.bootstrap("invoke", "create", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), packageDto, multipartFile)));
    }

    @PostMapping(value={"/files/default"})
    public ResponseEntity<String> fileDefault(@RequestParam(value="packageFileId") Integer packageFileId, @RequestParam(value="packageId") Integer packageId) {
        IndyInterface.bootstrap("invoke", "fileDefault", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), packageId, packageFileId);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, "success"));
    }

    @PostMapping(value={"/files/upload"})
    public ResponseEntity upload(@RequestParam(value="upload") MultipartFile multipartFile, @RequestParam(value="packageId") Integer packageId) {
        CallSite packageFileDto = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "uploadFile", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), packageId, multipartFile));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, packageFileDto));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PackageDto> update(@RequestBody PackageDto model, @PathVariable(value="id") Integer id) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), id, model)));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<String> destroy(@PathVariable(value="id") Integer id) {
        IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, "success"));
    }

    @DeleteMapping(value={"/files/{id}"})
    public ResponseEntity<String> destroyFile(@PathVariable(value="id") Integer id) {
        IndyInterface.bootstrap("invoke", "deleteFile", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, "success"));
    }

    @GetMapping(value={"/options", "/options/"})
    public ResponseEntity<List<WebixOptionsDto>> options(@RequestParam(name="projectId", required=false) Optional<Integer> projectId, @RequestParam(name="type", required=false) Optional<PackageType> type) {
        Reference type2 = new Reference(type);
        CallSite userId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "userId", 0, this.authenticationUser));
        CallSite list = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "present", 0, projectId)) != false ? IndyInterface.bootstrap("invoke", "listPackage", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), IndyInterface.bootstrap("invoke", "get", 0, projectId), userId) : IndyInterface.bootstrap("invoke", "listPackage", 0, IndyInterface.bootstrap("getProperty", "package", 0, this.servicesFactory), userId));
        List result = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "stream", 0, list), new _options_closure1((Object)this, (Object)this, type2)), new _options_closure2((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)), List.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, result));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PackageRestControllerV1.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

