/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.config;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import ru.easydata.scheduler.backend.config.License;
import ru.easydata.scheduler.backend.factories.ServicesFactory;
import ru.easydata.scheduler.backend.job_rule.JobRuleManager;
import ru.easydata.scheduler.backend.service.OperatorHistoryService;
import ru.easydata.scheduler.backend.service.RuntimeSystemStatisticService;

@EnableScheduling
@Configuration
class SchedulingConfiguration {
    private final ServicesFactory servicesFactory;
    private final OperatorHistoryService operatorHistoryService;
    private final JobRuleManager jobRuleManager;
    private final License license;
    private final RuntimeSystemStatisticService runtimeSystemStatisticService;

    @Autowired
    public SchedulingConfiguration(ServicesFactory servicesFactory, OperatorHistoryService operatorHistoryService, JobRuleManager jobRuleManager, License license, RuntimeSystemStatisticService runtimeSystemStatisticService) {
        this.servicesFactory = servicesFactory;
        this.operatorHistoryService = operatorHistoryService;
        this.jobRuleManager = jobRuleManager;
        this.license = license;
        this.runtimeSystemStatisticService = runtimeSystemStatisticService;
    }

    @Bean
    Executor schedulerExecutor() {
        return Executors.newScheduledThreadPool(10);
    }

    @Scheduled(fixedRate=60000L)
    void deleteOldLogFile() {
    }

    @Scheduled(fixedRate=60000L)
    void synchronizationOperatorHistory() {
        this.operatorHistoryService.synchronization();
    }

    @Scheduled(fixedRate=60000L)
    void subscribeSend() {
        this.servicesFactory.getSubscribe().sendAll();
    }

    @Scheduled(fixedRate=60000L)
    void runtimeSystemStatisticLoad() {
        this.runtimeSystemStatisticService.load();
    }

    @Scheduled(cron="0 0 3 * * ?")
    void runtimeSystemStatisticDeleteOld() {
        this.runtimeSystemStatisticService.deleteOld();
    }

    @Scheduled(fixedRate=5000L)
    void jobRuleExecution() {
        this.jobRuleManager.execution();
    }

    @Scheduled(cron="0 0 0 * * ?")
    void initLicense() {
        this.license.init();
    }

    @Scheduled(cron="0 0 1 * * ?")
    void subscribeDeleteOld() {
        this.servicesFactory.getSubscribe().deleteOld();
    }

    @Scheduled(cron="0 0 2 * * ?")
    void operatorHistoryDeleteOld() {
        this.servicesFactory.getOperatorHistory().deleteOld();
    }
}

