/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.runtime.controller.rest.v1;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.easydata.scheduler.runtime.components.RuntimeStorage;
import ru.easydata.scheduler.runtime.config.AppProperties;
import ru.easydata.scheduler.runtime.config.Version;
import ru.easydata.scheduler.runtime.entities.SchedulerEntity;
import ru.easydata.scheduler.runtime.entities.SystemStatisticEntity;
import ru.easydata.scheduler.runtime.services.StatisticService;
import ru.easydata.scheduler.worker.dto.FileBody;
import ru.easydata.scheduler.worker.dto.SystemInfoDto;
import ru.easydata.scheduler.worker.executors.ExecutorReport;
import ru.easydata.scheduler.worker.executors.ExecutorRepository;
import ru.easydata.scheduler.worker.operators.Operator;
import ru.easydata.scheduler.worker.operators.OperatorProperty;
import ru.easydata.scheduler.worker.workers.local.LocalWorker;
import ru.easydata.scheduler.worker.workers.local.LocalWorkerProperty;

@RestController
@RequestMapping(value={"/runtime/api/v1"})
public class RuntimeRestControllerV1
implements GroovyObject {
    @Autowired
    private LocalWorker localWorker;
    @Autowired
    private RuntimeStorage runtimeStorage;
    @Autowired
    private SchedulerEntity authenticationUser;
    @Autowired
    private ExecutorRepository executorRepository;
    @Autowired
    private AppProperties appProperties;
    @Autowired
    private Version version;
    @Autowired
    private StatisticService statisticService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RuntimeRestControllerV1() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private LocalWorkerProperty getLocalWorkerProperty() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GetMapping(value={"system/info"})
    public ResponseEntity<SystemInfoDto> systemInfo() {
        CallSite systemInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SystemInfoDto.class, IndyInterface.bootstrap("getProperty", "storage", 0, IndyInterface.bootstrap("getProperty", "path", 0, this.appProperties))));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, systemInfo, IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"version"})
    public ResponseEntity<Map<String, String>> version() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", IndyInterface.bootstrap("getProperty", "version", 0, this.version), "versionDate", IndyInterface.bootstrap("getProperty", "versionDate", 0, this.version)})));
    }

    @GetMapping(value={"system/statistics"})
    public ResponseEntity<SystemStatisticEntity> listSystemStatistics(@RequestParam(value="date") Timestamp date) {
        CallSite listSystemStatistics = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listSystemStatistics", 0, this.statisticService, date));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, listSystemStatistics, IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"system/start"})
    public ResponseEntity<Date> systemStart() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, IndyInterface.bootstrap("getProperty", "RUNTIME_START_DATE", 0, AppProperties.class), IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"executor/list"})
    public ResponseEntity<Set<ExecutorReport>> executorList() {
        CallSite list = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "list", 0, this.localWorker, IndyInterface.bootstrap("getProperty", "localWorkerProperty", 4, this)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, list, IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"executor/list/size"})
    public ResponseEntity<Integer> executorListSize() {
        CallSite list = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "list", 0, this.localWorker, IndyInterface.bootstrap("getProperty", "localWorkerProperty", 4, this)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, IndyInterface.bootstrap("invoke", "size", 0, list), IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @PostMapping(value={"executor/list/clear"})
    public ResponseEntity<String> executorListClear() {
        IndyInterface.bootstrap("invoke", "deleteAll", 0, this.executorRepository);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @PostMapping(value={"executor/requestReport"})
    public ResponseEntity<String> executorRequestReport(@RequestParam(value="id") Long id) {
        IndyInterface.bootstrap("invoke", "requestReport", 0, this.localWorker, id, IndyInterface.bootstrap("getProperty", "localWorkerProperty", 4, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @PostMapping(value={"executor/start"})
    public ResponseEntity<String> executorStart(@RequestBody Operator<OperatorProperty> operator) {
        IndyInterface.bootstrap("invoke", "start", 0, this.localWorker, operator, IndyInterface.bootstrap("getProperty", "localWorkerProperty", 4, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @PostMapping(value={"executor/stop"})
    public ResponseEntity<String> executorStop(@RequestParam(value="id") Long id) {
        IndyInterface.bootstrap("invoke", "stop", 0, this.localWorker, id, IndyInterface.bootstrap("getProperty", "localWorkerProperty", 4, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"log/text"})
    public ResponseEntity<FileBody> logText(@RequestParam(value="id") Long id, @RequestParam(name="firstLine", required=false) Optional<Integer> firstLine) {
        CallSite fileBody = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLogText", 0, this.localWorker, id, IndyInterface.bootstrap("invoke", "getLocalWorkerProperty", 2, this), IndyInterface.bootstrap("invoke", "orElse", 0, firstLine, false)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, fileBody, IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @GetMapping(value={"log/file"})
    public ResponseEntity<Resource> logFile(@RequestParam(value="id") Long id) {
        CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLogFile", 0, this.runtimeStorage, id));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fileUpload", 2, this, file));
    }

    @DeleteMapping(value={"log/delete"})
    public ResponseEntity<String> logDelete(@RequestParam(value="id") Long id) {
        IndyInterface.bootstrap("invoke", "logDelete", 0, this.runtimeStorage, id);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @DeleteMapping(value={"log/clear"})
    public ResponseEntity<String> logClear() {
        IndyInterface.bootstrap("invoke", "logClearAll", 0, this.runtimeStorage);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @DeleteMapping(value={"package/delete"})
    public ResponseEntity<String> packageDelete(@RequestParam(value="code") String code) {
        IndyInterface.bootstrap("invoke", "packageDelete", 0, this.runtimeStorage, code);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    @DeleteMapping(value={"package/clear"})
    public ResponseEntity<String> packageDelete() {
        IndyInterface.bootstrap("invoke", "packageClearAll", 0, this.runtimeStorage);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, "success", IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    private ResponseEntity<Resource> fileUpload(File file) {
        CallSite resource = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, InputStreamResource.class, IndyInterface.bootstrap("init", "<init>", 0, FileInputStream.class, file)));
        CallSite md5 = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "exists", 0, file)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFile", 0, file))) {
            CallSite is = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInputStream", 0, Files.class, IndyInterface.bootstrap("invoke", "toPath", 0, file)));
            Throwable __$$primaryExc0 = null;
            try {
                try {
                    md5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "md5Hex", 0, DigestUtils.class, is));
                }
                catch (Throwable __$$t0) {
                    __$$primaryExc0 = __$$t0;
                    throw __$$t0;
                }
            }
            finally {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)__$$primaryExc0, null)) {
                    try {
                        IndyInterface.bootstrap("invoke", "close", 1, is);
                    }
                    catch (Throwable __$$suppressedExc0) {
                        IndyInterface.bootstrap("invoke", "addSuppressed", 1, __$$primaryExc0, __$$suppressedExc0);
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "close", 1, is);
                }
            }
        }
        CallSite header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HttpHeaders.class));
        IndyInterface.bootstrap("invoke", "add", 0, header, IndyInterface.bootstrap("getProperty", "CONTENT_DISPOSITION", 0, HttpHeaders.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, file)}, new String[]{"attachment; filename=", ""}));
        IndyInterface.bootstrap("invoke", "add", 0, header, IndyInterface.bootstrap("getProperty", "CACHE_CONTROL", 0, HttpHeaders.class), "no-cache, no-store, must-revalidate");
        IndyInterface.bootstrap("invoke", "add", 0, header, IndyInterface.bootstrap("getProperty", "PRAGMA", 0, HttpHeaders.class), "no-cache");
        IndyInterface.bootstrap("invoke", "add", 0, header, IndyInterface.bootstrap("getProperty", "EXPIRES", 0, HttpHeaders.class), "0");
        IndyInterface.bootstrap("invoke", "add", 0, header, "md5Hex", md5);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "body", 0, IndyInterface.bootstrap("invoke", "contentType", 0, IndyInterface.bootstrap("invoke", "contentLength", 0, IndyInterface.bootstrap("invoke", "headers", 0, IndyInterface.bootstrap("invoke", "ok", 0, ResponseEntity.class), header), IndyInterface.bootstrap("invoke", "length", 0, file)), IndyInterface.bootstrap("invoke", "parseMediaType", 0, MediaType.class, "application/octet-stream")), resource));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RuntimeRestControllerV1.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RuntimeRestControllerV1.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RuntimeRestControllerV1.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RuntimeRestControllerV1.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RuntimeRestControllerV1.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RuntimeRestControllerV1.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

