/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.runtime.config;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import ru.easydata.scheduler.runtime.config.AppProperties;
import ru.easydata.scheduler.runtime.services.StatisticService;

@EnableScheduling
@Configuration
class SchedulingConfiguration {
    private final StatisticService statisticService;
    private final AppProperties appProperties;

    public SchedulingConfiguration(StatisticService statisticService, AppProperties appProperties) {
        this.statisticService = statisticService;
        this.appProperties = appProperties;
    }

    @Bean
    Executor schedulerExecutor() {
        return Executors.newScheduledThreadPool(10);
    }

    @Scheduled(cron="0 0 0 * * ?")
    void statisticsDeleteOld() {
        this.statisticService.systemStatisticsDeleteOld();
    }
}

