/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;
import ru.easydata.scheduler.backend.dto.PackageDto;
import ru.easydata.scheduler.backend.dto.PackageFileDto;
import ru.easydata.scheduler.backend.entities.ProjectEntity;
import ru.easydata.scheduler.backend.exception.SchedulerClientException;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.PackageFileMapper;
import ru.easydata.scheduler.backend.mappers.PackageMapper;
import ru.easydata.scheduler.backend.service.PackageService;
import ru.easydata.scheduler.backend.service.impl.Package;
import ru.easydata.scheduler.backend.service.impl.PackageImpl;
import ru.easydata.scheduler.worker.dto.PackageInfoDto;

@Service(value="packageService")
@Lazy
@Validated
public class PackageImpl
extends Package
implements PackageService {
    @Autowired
    protected PackageMapper packageMapper;
    @Autowired
    protected PackageFileMapper packageFileMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private final Object $lock;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PackageImpl() {
        Object[] objectArray;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.$lock = objectArray = new Object[Integer.valueOf(0).intValue()];
    }

    public List<PackageDto> listPackage() {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllPackage", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "ASC", 0, Sort.Direction.class), "code")));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, packageEntity), new _listPackage_closure1((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public List<PackageDto> listPackage(Integer userId) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllByUser", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), userId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, packageEntity), new _listPackage_closure2((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public List<PackageDto> listPackage(Integer projectId, Integer userId) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllByProject", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), projectId, userId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, packageEntity), new _listPackage_closure3((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public List<PackageFileDto> listFile(Integer packageId) {
        CallSite packageFileEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllByPackId", 0, IndyInterface.bootstrap("getProperty", "packageFileRepository", 4, this), packageId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, packageFileEntities), new _listFile_closure4((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public PackageDto get(Integer packageId) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findById", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), packageId)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.packageMapper, packageEntity));
    }

    @Transactional
    public PackageDto create(PackageDto dto, MultipartFile multipartFile) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            PackageDto packageDto = dto;
            valueRecorder.record((Object)packageDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, packageDto);
            valueRecorder.record((Object)callSite, 13);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.packageMapper, dto));
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ProjectEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "projectId", 4, dto)}));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, PackageImpl.class, (GroovyObject)packageEntity, (String)"project");
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.packageMapper, IndyInterface.bootstrap("invoke", "doCreate", 2, this, packageEntity, multipartFile)));
        try {
            return callSite2;
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "deleteDirectory", 0, FileUtils.class, IndyInterface.bootstrap("invoke", "packageDir", 2, this, packageEntity));
            throw (Throwable)e;
        }
    }

    public PackageDto update(Integer packageId, PackageDto dto) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            PackageDto packageDto = dto;
            valueRecorder.record((Object)packageDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, packageDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            PackageDto packageDto = dto;
            valueRecorder2.record((Object)packageDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, packageDto);
            valueRecorder2.record((Object)callSite, 12);
            Integer n = packageId;
            valueRecorder2.record((Object)n, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder2.record((Object)bl, 15);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id == packageId", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), IndyInterface.bootstrap("invoke", "map", 0, this.packageMapper, dto)));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.packageMapper, packageEntity));
        try {
            return callSite;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    @Transactional
    public PackageFileDto uploadFile(Integer packageId, MultipartFile multipartFile) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageId));
        CallSite packageDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "packageDir", 2, this, packageEntity));
        CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "uploadPackageFile", 2, this, packageDir, multipartFile));
        CallSite defineType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "defineTypePackage", 2, this, file));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "type", 4, packageEntity), (Object)IndyInterface.bootstrap("invoke", "type", 0, defineType))) {
            IndyInterface.bootstrap("invoke", "delete", 0, file);
            IndyInterface.bootstrap("invoke", "deleteDirectory", 0, FileUtils.class, IndyInterface.bootstrap("invoke", "directory", 0, defineType));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerClientException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 4, packageEntity)}, new String[]{"\u041d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430, \u043d\u0443\u0436\u0435\u043d ", ""})));
        }
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "savePackageFileEntity", 2, this, packageEntity, file));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, packageFileEntity);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, PackageImpl.class, (GroovyObject)packageEntity, (String)"packageFileId");
        IndyInterface.bootstrap("invoke", "savePackageEntity", 2, this, packageEntity);
        CallSite packageInitClass = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "initClass", 0, defineType));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)packageInitClass, null)) {
            IndyInterface.bootstrap("invoke", "init", 0, IndyInterface.bootstrap("invoke", "getBean", 0, IndyInterface.bootstrap("getProperty", "applicationContext", 4, this), packageInitClass), defineType, packageEntity);
        }
        IndyInterface.bootstrap("invoke", "deleteDirectory", 0, FileUtils.class, IndyInterface.bootstrap("invoke", "directory", 0, defineType));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.packageFileMapper, packageFileEntity));
    }

    public boolean fileDefault(Integer packageId, Integer packageFileId) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageId));
        Integer n = packageFileId;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, PackageImpl.class, (GroovyObject)packageEntity, (String)"packageFileId");
        IndyInterface.bootstrap("invoke", "savePackageEntity", 2, this, packageEntity);
        return true;
    }

    @Transactional
    public boolean delete(Integer packageId) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageId));
        try {
            IndyInterface.bootstrap("invoke", "deleteDirectory", 0, FileUtils.class, IndyInterface.bootstrap("invoke", "packageDir", 2, this, packageEntity));
            IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("getProperty", "packageRepository", 4, this), packageEntity);
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    @Transactional
    public boolean deleteFile(Integer packageFileId) {
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, packageFileId));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "id", 4, packageFileEntity), (Object)IndyInterface.bootstrap("getProperty", "packageFileId", 0, IndyInterface.bootstrap("getProperty", "pack", 4, packageFileEntity)))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, "\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0444\u0430\u043b"));
        }
        try {
            IndyInterface.bootstrap("invoke", "delete", 0, FileUtils.class, IndyInterface.bootstrap("invoke", "packageFile", 2, this, packageFileEntity));
            IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("getProperty", "packageFileRepository", 4, this), packageFileEntity);
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
        return true;
    }

    public PackageInfoDto packageInfo(String packageCode) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageCode));
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, IndyInterface.bootstrap("getProperty", "packageFileId", 4, packageEntity)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PackageInfoDto.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"code", IndyInterface.bootstrap("getProperty", "code", 4, packageEntity), "packageId", IndyInterface.bootstrap("getProperty", "id", 4, packageEntity), "packageFileId", IndyInterface.bootstrap("getProperty", "id", 4, packageFileEntity), "version", IndyInterface.bootstrap("getProperty", "version", 4, packageFileEntity), "versionDirectoryName", IndyInterface.bootstrap("getProperty", "versionDirectoryName", 4, packageFileEntity), "packageDirectoryName", IndyInterface.bootstrap("getProperty", "directoryName", 4, packageEntity)})));
    }

    public File findFile(Integer packageFileId) {
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, packageFileId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "packageFile", 2, this, packageFileEntity));
    }

    public File findFile(String packageCode) {
        CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageCode));
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, IndyInterface.bootstrap("getProperty", "packageFileId", 4, packageEntity)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "packageFile", 2, this, packageFileEntity));
    }

    public File findFile(String packageCode, String packageVersion) {
        CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, packageCode, packageVersion));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "packageFile", 2, this, packageFileEntity));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File findSourceDirectory(String packageCode, boolean upload) {
        Object object = this.$lock;
        synchronized (object) {
            CallSite packageEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageEntity", 2, this, packageCode));
            CallSite packageFileEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findPackageFileEntity", 2, this, IndyInterface.bootstrap("getProperty", "packageFileId", 4, packageEntity)));
            CallSite sourceDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "packageDir", 2, this, packageEntity), IndyInterface.bootstrap("getProperty", "versionDirectoryName", 4, packageFileEntity)));
            if (!(upload && (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, sourceDir)) == false || ScriptBytecodeAdapter.compareLessThanEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "listFiles", 0, sourceDir)), (Object)0)))) return sourceDir;
            IndyInterface.bootstrap("invoke", "extractSourceFile", 2, this, sourceDir, IndyInterface.bootstrap("invoke", "packageFile", 2, this, packageFileEntity));
            return sourceDir;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PackageImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.backend.service.impl.PackageImpl");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

