/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.repositoryes;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;
import ru.easydata.scheduler.backend.entities.OperatorStructureEntity;
import ru.easydata.scheduler.backend.enums.OperatorCategory;

public interface OperatorStructureRepository
extends JpaRepository<OperatorStructureEntity, Integer> {
    @Query(value="SELECT ws FROM OperatorStructureEntity ws WHERE ws.workflowId = :workflowId")
    public List<OperatorStructureEntity> findAllByWorkflowId(@Param(value="workflowId") Integer var1);

    @Query(value="SELECT os FROM OperatorStructureEntity os WHERE os.workflowId = :workflowId AND os.category = 'START'")
    public Optional<OperatorStructureEntity> findStartStep(@Param(value="workflowId") Integer var1);

    @Query(value="SELECT os FROM OperatorStructureEntity os WHERE os.parentId = :parentId AND os.category = :category AND os.isEnabled = true ORDER BY os.orderCategory")
    public List<OperatorStructureEntity> findAllOperatorByStep(@Param(value="parentId") Integer var1, @Param(value="category") OperatorCategory var2);

    @Query(value="SELECT os FROM OperatorStructureEntity os WHERE os.parentId = :parentId ORDER BY os.orderCategory")
    public List<OperatorStructureEntity> findAllOperatorByStep(@Param(value="parentId") Integer var1);

    @Query(value="SELECT os FROM OperatorStructureEntity os WHERE os.parentId = (SELECT t.parentId FROM OperatorStructureEntity t WHERE t.id = :structureId)")
    public List<OperatorStructureEntity> findAllByParentStep(@Param(value="structureId") Integer var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE OperatorStructureEntity os SET os.status = 'INIT' WHERE os.parentId = :parentId AND os.category = 'OPERATOR'")
    public int setInitForOperatorStep(@Param(value="parentId") Integer var1);
}

