/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.mappers;

import org.springframework.stereotype.Component;
import ru.easydata.scheduler.backend.dto.PackageFileDto;
import ru.easydata.scheduler.backend.entities.PackageEntity;
import ru.easydata.scheduler.backend.entities.PackageFileEntity;
import ru.easydata.scheduler.backend.mappers.PackageFileMapper;

@Component
public class PackageFileMapperImpl
implements PackageFileMapper {
    public PackageFileDto map(PackageFileEntity entity) {
        if (entity == null) {
            return null;
        }
        PackageFileDto packageFileDto = new PackageFileDto();
        packageFileDto.setPackageId(this.entityPackId(entity));
        packageFileDto.setPackageCode(this.entityPackCode(entity));
        packageFileDto.setId(entity.getId());
        packageFileDto.setFileName(entity.getFileName());
        packageFileDto.setVersion(entity.getVersion());
        packageFileDto.setDateUpload(entity.getDateUpload());
        packageFileDto.setChecksum(entity.getChecksum());
        packageFileDto.setSize(entity.getSize());
        return packageFileDto;
    }

    public PackageFileEntity map(PackageFileDto dto) {
        if (dto == null) {
            return null;
        }
        PackageFileEntity packageFileEntity = new PackageFileEntity();
        packageFileEntity.setPack(this.packageFileDtoToPackageEntity(dto));
        packageFileEntity.setId(dto.getId());
        packageFileEntity.setFileName(dto.getFileName());
        packageFileEntity.setVersion(dto.getVersion());
        packageFileEntity.setDateUpload(dto.getDateUpload());
        packageFileEntity.setChecksum(dto.getChecksum());
        packageFileEntity.setSize(dto.getSize());
        return packageFileEntity;
    }

    private Integer entityPackId(PackageFileEntity packageFileEntity) {
        if (packageFileEntity == null) {
            return null;
        }
        PackageEntity pack = packageFileEntity.getPack();
        if (pack == null) {
            return null;
        }
        Integer id = pack.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String entityPackCode(PackageFileEntity packageFileEntity) {
        if (packageFileEntity == null) {
            return null;
        }
        PackageEntity pack = packageFileEntity.getPack();
        if (pack == null) {
            return null;
        }
        String code = pack.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    protected PackageEntity packageFileDtoToPackageEntity(PackageFileDto packageFileDto) {
        if (packageFileDto == null) {
            return null;
        }
        PackageEntity packageEntity = new PackageEntity();
        packageEntity.setId(packageFileDto.getPackageId());
        packageEntity.setCode(packageFileDto.getPackageCode());
        return packageEntity;
    }
}

